<?php
/**
 * The template for displaying the header
 *
 * Displays all of the head element and everything up until the "site-content" div.
 *
 * @package WordPress
 * @subpackage Superio
 * @since Superio 1.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js">
<head>
	<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "Corporation",
  "name": "Kiemviec247.com - Trang thông tin tuyển dụng, việc làm, tìm việc đa lĩnh vực",
  "alternateName": "Kiemviec247",
  "url": "https://kiemviec247.com",
  "logo": "https://kiemviec247.com/wp-content/uploads/elementor/thumbs/logo-kiemviec-qic6by2hqt9yw8qze3qenstr6hzs2rgsnh1vuf46xm.png",
  "contactPoint": {
    "@type": "ContactPoint",
    "telephone": "0855 278 407",
    "contactType": "technical support",
    "contactOption": "TollFree",
    "areaServed": "VN",
    "availableLanguage": "Vietnamese"
  },
  "sameAs": [
    "https://www.youtube.com/@kiemviec247/about",
    "https://www.pinterest.com/kiemviec247/",
    "https://www.linkedin.com/in/kiemviec247/",
    "https://twitter.com/kiemviec247",
    "https://www.reddit.com/user/kiemviec247/",
    "https://kiemviec247.tumblr.com/",
    "https://sites.google.com/view/kiemviec247",
    "https://www.blogger.com/profile/00927529489209436472"
  ]
}
</script>
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "ProfessionalService",
  "name": "Kiemviec247.com - Trang thông tin tuyển dụng, việc làm, tìm việc đa lĩnh vực",
  "image": "https://kiemviec247.com/wp-content/uploads/elementor/thumbs/logo-kiemviec-qic6by2hqt9yw8qze3qenstr6hzs2rgsnh1vuf46xm.png",
  "@id": "https://kiemviec247.com",
  "url": "https://kiemviec247.com",
  "telephone": "0855 278 407",
  "address": {
    "@type": "PostalAddress",
    "streetAddress": "15 Hẻm 310 Dương Quảng Hàm, Phường 5, Gò Vấp, Thành phố Hồ Chí Minh, Việt Nam",
    "addressLocality": "Thành phố Hồ Chí Minh",
    "postalCode": "70000",
    "addressCountry": "VN"
  },
  "geo": {
    "@type": "GeoCoordinates",
    "latitude": 10.8304818,
    "longitude": 106.6882916
  },
  "openingHoursSpecification": {
    "@type": "OpeningHoursSpecification",
    "dayOfWeek": [
      "Monday",
      "Tuesday",
      "Wednesday",
      "Thursday",
      "Friday",
      "Saturday",
      "Sunday"
    ],
    "opens": "00:00",
    "closes": "23:59"
  },
  "sameAs": [
    "https://www.youtube.com/@kiemviec247/about",
    "https://www.pinterest.com/kiemviec247/",
    "https://www.linkedin.com/in/kiemviec247/",
    "https://twitter.com/kiemviec247",
    "https://www.reddit.com/user/kiemviec247/",
    "https://kiemviec247.tumblr.com/",
    "https://sites.google.com/view/kiemviec247",
    "https://www.blogger.com/profile/00927529489209436472"
  ] 
}
</script>
	<script type="application/ld+json">
{
  "@context": "https://schema.org/",
  "@type": "Person",
  "name": "Nguyễn Cao Minh",
  "url": "https://kiemviec247.com/author/admin/",
  "image": "https://kenh14cdn.com/2018/7/26/photo-1-1532606811915675956498.jpg",
  "sameAs": [
    "https://www.youtube.com/@ceonguyencaominh/about",
    "https://www.pinterest.com/ceonguyencaominh/",
    "https://www.linkedin.com/in/nguyencaominh/",
    "https://twitter.com/_nguyencaominh",
    "https://www.reddit.com/user/nguyencaominh/",
    "https://nguyencaominh.tumblr.com/",
    "https://sites.google.com/view/nguyencaominh",
    "https://www.blogger.com/profile/04122401344209606865"
  ],
  "jobTitle": "CEO",
  "worksFor": {
    "@type": "Organization",
    "name": "Kiếm việc 247"
  }  
}
</script>
	
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width">
	<link rel="profile" href="//gmpg.org/xfn/11">
	
	<?php wp_head(); ?>
	<!-- Google tag (gtag.js) -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-7HFB8HT7CZ"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-7HFB8HT7CZ');
</script>
	<meta name="google-site-verification" content="9f4ri5N50pBjkr1DW3xM2oDEjroqSSNYQJhtu5r-Vcg" />
	<meta name='dmca-site-verification' content='NHJTQzVTRktReXhFZnVBeGxoS1d3Zz090' />
</head>
<body <?php body_class(); ?>>
<?php if ( superio_get_config('preload', true) ) {
	$preload_icon = superio_get_config('media-preload-icon');
	$styles = array();
	if ( !empty($preload_icon['id']) ) {
		$img = wp_get_attachment_image_src($preload_icon['id'], 'full');
		if ( !empty($img[0]) ) {
			$styles[] = 'background-image: url(\''.$img[0].'\');';
		}
		if ( !empty($img[1]) ) {
			$styles[] = 'width: '.$img[1].'px;';
		}
		if ( !empty($img[1]) ) {
			$styles[] = 'height: '.$img[2].'px;';
		}
    }
    $style_attr = '';
    if ( !empty($styles) ) {
    	$style_attr = 'style="'.implode(' ', $styles).'"';
    }
?>
	<div class="apus-page-loading">
        <div class="apus-loader-inner" <?php echo trim($style_attr); ?>></div>
    </div>
<?php } ?>
<div id="wrapper-container" class="wrapper-container">
	<?php
    if ( function_exists( 'wp_body_open' ) ) {
        wp_body_open();
    }
    if ( superio_get_config('separate_header_mobile', true) ) {
	    get_template_part( 'headers/mobile/offcanvas-menu' );
		get_template_part( 'headers/mobile/header-mobile' );
	}
	?>

	<?php
		$header = apply_filters( 'superio_get_header_layout', superio_get_config('header_type') );
		if ( !empty($header) ) {
			superio_display_header_builder($header);
		} else {
			get_template_part( 'headers/default' );
		}
	?>
	<div id="apus-main-content">